# 画面設計書 48-kubeadm token

## 概要

本ドキュメントは、kubeadmのtokenコマンドの画面設計書である。Kubernetesクラスタのブートストラップトークンの作成、一覧表示、削除を管理するCLIコマンドの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：ブートストラップトークンは、新しいノードがクラスタに参加する際の双方向信頼確立に使用される。tokenコマンドは、トークンのライフサイクル管理（作成、一覧、削除、生成）を提供し、クラスタのノード参加プロセスを制御する。トークンはkube-system名前空間のSecret（type: bootstrap.kubernetes.io/token）として保存される。

**画面へのアクセス方法**：ターミナルから `kubeadm token SUBCOMMAND [flags]` を実行する。

**主要な操作・処理内容**：
1. `kubeadm token create [token]` - 新しいブートストラップトークンをサーバに作成する。オプションでjoinコマンドの出力も可能
2. `kubeadm token list` - サーバ上の既存ブートストラップトークン一覧を表示する
3. `kubeadm token delete <token-id>...` - 指定されたトークンをサーバから削除する
4. `kubeadm token generate` - ランダムトークンを生成して表示する（サーバ不要）

**画面遷移**：token createで生成されたトークンはkubeadm joinの--tokenフラグで使用される。

**権限による表示制御**：create/list/deleteはAPI Serverへのアクセスが必要。generateはローカル実行のみ。--dry-runフラグでシミュレーション可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 118 | クラスター初期化（init） | 補助機能 | クラスター参加用ブートストラップトークンの作成・一覧・削除を行う |
| 2 | 認証（Authentication） | API連携 | トークンベースの認証情報を管理する |

## 画面種別

管理操作（CLIサブコマンド構造）

## URL/ルーティング

```
kubeadm token create [token] [flags]
kubeadm token list [flags]
kubeadm token delete <token-value>... [flags]
kubeadm token generate
```

## 入出力項目

### 入力項目（共通フラグ）

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|------|------|-----------|------|
| --kubeconfig | string | 任意 | /etc/kubernetes/admin.conf | kubeconfigファイルパス |
| --dry-run | bool | 任意 | false | ドライラン実行 |

### 入力項目（createサブコマンド）

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|------|------|-----------|------|
| [token] | string | 任意 | 自動生成 | トークン文字列（[a-z0-9]{6}.[a-z0-9]{16}形式） |
| --config | string | 任意 | "" | 設定ファイルパス |
| --print-join-command | bool | 任意 | false | joinコマンド全体を出力 |
| --certificate-key | string | 任意 | "" | CP参加用joinコマンド出力時の証明書キー |
| --ttl | duration | 任意 | 24h | トークンの有効期限 |
| --usages | []string | 任意 | signing,authentication | トークンの用途 |
| --groups | []string | 任意 | system:bootstrappers:kubeadm:default-node-token | トークンのグループ |
| --description | string | 任意 | "" | トークンの説明 |

### 入力項目（deleteサブコマンド）

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|------|------|-----------|------|
| <token-value> | string | 必須 | - | 削除するトークン値またはトークンID（1つ以上） |

### 出力項目

| サブコマンド | 出力内容 |
|-------------|---------|
| create | トークン文字列、または --print-join-command 指定時はjoinコマンド全体 |
| list | トークン一覧テーブル（TOKEN, TTL, EXPIRES, USAGES, DESCRIPTION, EXTRA GROUPS） |
| delete | 削除確認メッセージ |
| generate | ランダム生成されたトークン文字列 |

## 表示項目

list出力例：
```
TOKEN                     TTL         EXPIRES                     USAGES                   DESCRIPTION                                                EXTRA GROUPS
abcdef.0123456789abcdef   23h         2024-12-19T10:30:00Z        authentication,signing   The default bootstrap token generated by 'kubeadm init'.   system:bootstrappers:kubeadm:default-node-token
```

create + --print-join-command出力例：
```
kubeadm join 192.168.1.1:6443 --token abcdef.0123456789abcdef --discovery-token-ca-cert-hash sha256:...
```

## イベント仕様

### 1-token create実行

1. トークン値のバリデーション（指定時）
2. kubeconfigからClientSetを作成
3. 設定ファイルまたはデフォルト設定をロード
4. `tokenphase.CreateNewTokens()` でSecretを作成
5. `--print-join-command` 指定時はjoinコマンド文字列を構築して出力

### 2-token list実行

1. kubeconfigからClientSetを作成
2. `type=bootstrap.kubernetes.io/token` のフィールドセレクタでSecretを検索
3. 各SecretからBootstrapToken構造体に変換
4. テーブル形式で出力

### 3-token delete実行

1. 引数のバリデーション（1つ以上必須）
2. トークンIDまたはフルトークンからIDを抽出
3. `bootstrap-token-<id>` 名のSecretを削除

### 4-token generate実行

1. `bootstraputil.GenerateBootstrapToken()` でランダムトークンを生成
2. 標準出力に出力（サーバアクセスなし）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| create | Secret (kube-system/bootstrap-token-*) | INSERT | ブートストラップトークンSecretの作成 |
| list | Secret (kube-system/bootstrap-token-*) | SELECT | ブートストラップトークンSecretの一覧取得 |
| delete | Secret (kube-system/bootstrap-token-*) | DELETE | ブートストラップトークンSecretの削除 |
| generate | なし | なし | ローカルでのトークン生成のみ |

### テーブル別更新項目詳細

#### Secret (bootstrap-token-*)

| 操作 | 項目（キー） | 更新値・取得条件 | 備考 |
|-----|-------------|-----------------|------|
| INSERT | type | bootstrap.kubernetes.io/token | Secret種別 |
| INSERT | data[token-id] | トークンIDの6文字部分 | |
| INSERT | data[token-secret] | トークンシークレットの16文字部分 | |
| INSERT | data[description] | ユーザ指定の説明 | |
| INSERT | data[expiration] | TTLから計算された有効期限 | |
| INSERT | data[usage-bootstrap-signing] | "true" | usagesに応じて設定 |
| INSERT | data[auth-extra-groups] | グループ名（カンマ区切り） | |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 条件 |
|-------------|------|----------|------|
| INFO-01 | 情報 | `bootstrap token %q deleted` | トークン削除成功時 |
| ERR-01 | エラー | `missing argument; 'token delete' is missing token` | delete時に引数なし |
| ERR-02 | エラー | `given token didn't match pattern...` | 不正なトークン形式 |
| ERR-03 | エラー | `failed to list bootstrap tokens` | Secret一覧取得失敗 |
| ERR-04 | エラー | `failed to delete bootstrap token %q` | Secret削除失敗 |
| ERR-05 | エラー | `cannot use --certificate-key without --print-join-command` | 不正なフラグ組み合わせ |

## 例外処理

- kubeconfigの読み込みに失敗した場合はエラー終了
- トークン形式のバリデーション失敗時はエラー終了
- API Serverへのアクセス失敗時はエラー終了
- --certificate-keyは--print-join-commandと同時にのみ使用可能

## 備考

- トークン形式は `[a-z0-9]{6}.[a-z0-9]{16}` で、前半がパブリックID、後半がシークレット
- SecretはBootstrapTokenSecretName(tokenID)で命名される（`bootstrap-token-<id>`形式）
- DryRunモードではDeleteBootstrapTokenReactorを使用したフェイクClientが使われる
- list出力はテキスト形式がデフォルトだが、outputapischeme経由で他形式も対応可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | token.go | `cmd/kubeadm/app/cmd/token.go` | tokenTextPrinter構造体（行328-332）とformatBootstrapToken関数（行298-325）でlist出力形式を理解する |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | token.go | `cmd/kubeadm/app/cmd/token.go` | newCmdToken関数（行59-203）がルートコマンドを構築。4つのサブコマンド（create, generate, list, delete）を登録 |

**主要処理フロー**:
1. **行100-146**: createサブコマンド定義
2. **行147**: generateサブコマンド追加
3. **行151-176**: listサブコマンド定義
4. **行178-201**: deleteサブコマンド定義

#### Step 3: 各操作の実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | token.go | `cmd/kubeadm/app/cmd/token.go` | RunCreateToken（行230-284）でトークン作成とjoinコマンド生成。RunListTokens（行362-405）でSecret検索と変換。RunDeleteTokens（行408-431）でSecret削除 |

### プログラム呼び出し階層図

```
newCmdToken (token.go:59)
    |
    +-- create サブコマンド
    |       +-- RunCreateToken (token.go:230)
    |               +-- configutil.LoadOrDefaultInitConfiguration()
    |               +-- tokenphase.CreateNewTokens()
    |               +-- cmdutil.GetJoinWorkerCommand() (--print-join-command時)
    |
    +-- generate サブコマンド
    |       +-- RunGenerateToken (token.go:287)
    |               +-- bootstraputil.GenerateBootstrapToken()
    |
    +-- list サブコマンド
    |       +-- RunListTokens (token.go:362)
    |               +-- client.CoreV1().Secrets().List()
    |               +-- bootstraptokenv1.BootstrapTokenFromSecret()
    |               +-- printer.PrintObj()
    |
    +-- delete サブコマンド
            +-- RunDeleteTokens (token.go:408)
                    +-- bootstraputil.IsValidBootstrapTokenID()
                    +-- client.CoreV1().Secrets().Delete()
```

### データフロー図

```
[入力]                    [処理]                    [出力]

create:
  token/flags ──────> tokenphase.CreateNewTokens()──> Secret(kube-system)
                      cmdutil.GetJoinCommand()    ──> stdout (token/joinコマンド)

list:
  (なし) ──────────> client.Secrets().List() ──────> stdout (テーブル)
                    BootstrapTokenFromSecret()

delete:
  token-id ────────> client.Secrets().Delete() ───> stdout (確認メッセージ)

generate:
  (なし) ──────────> GenerateBootstrapToken() ────> stdout (トークン)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| token.go | `cmd/kubeadm/app/cmd/token.go` | ソース | tokenコマンド本体の実装 |
| bootstraptoken/ | `cmd/kubeadm/app/apis/bootstraptoken/v1/` | ソース | BootstrapToken型定義 |
| node/ | `cmd/kubeadm/app/phases/bootstraptoken/node/` | ソース | トークン作成フェーズの実装 |
| output/ | `cmd/kubeadm/app/apis/output/v1alpha3/` | ソース | 出力用API型定義 |
| util/ | `cmd/kubeadm/app/cmd/util/` | ソース | joinコマンド文字列生成ユーティリティ |
